

fn PxShowAbout =
(
	--sdkVersion = nvpxText.TXT_GUIMENUTOOLBAR_VER_UNKNOWN
	sdkVersion = nvpx.GetPhysXSDKVersionString()
	info = nvpxText.TXT_GUIMENUTOOLBAR_VER_INFO_PART1 + nvpx.GetPluginBuild() + nvpxText.TXT_GUIMENUTOOLBAR_VER_INFO_PART2 + sdkVersion + "\n" 
	messagebox info  title:nvpxText.TXT_GUIMENUTOOLBAR_VER_INFO_TITLE
)

fn PxCreateAs type = 
(
	-- stop simulation
	PxStopSimulation()
	
	if (type == PX_PHYSTYPE_DESTRUCTION) then
	(
		nvpx.CreateDestruction(PxGetSelectedNodes())
	)
	else
	(
				
		-- check whether there is node selected or not
		currentNode = PxGetCurrentNode()
		if currentNode != undefined then
		(
			if pxCurrentNodeType != type  then
			(
				test = PxGetRootParent currentNode
				
				if (PxGetSelectionCount() > 0) or IsGroupHead(test) or (SuperClassof(test) == GeometryClass) then
				(
					--format "create it as %, pxCurrentNodeType = %\n" type pxCurrentNodeType
					
					local errorInfo
					local target = #()
					case type of
					(
					PX_PHYSTYPE_UNDEFINED:  (target = PxGetSelectedNodes(); )
					PX_PHYSTYPE_DYNAMIC:    (PxDynamicRBNodes(PxGetSelectedNodes()); )
					PX_PHYSTYPE_CLOTH:      (target = PxGetSingleNodes()  ; if PxGetGroupNodesCount() > 0 then errorInfo = nvpxText.guiMenuNoGroupCloth)
					PX_PHYSTYPE_CLOTHING:   (PxAddApexClothingToNodes(PxGetSelectedNodes()); )
					PX_PHYSTYPE_SBCLOTHING: (PxAddApexSBClothingToNodes(PxGetSelectedNodes()); )
					PX_PHYSTYPE_SOFTBODY:   (target = PxGetSingleNodes()  ; if PxGetGroupNodesCount() > 0 then errorInfo = nvpxText.guiMenuNoGroupSB)
					PX_PHYSTYPE_FORCEFIELD: (target = PxGetSingleNodes()  ; if PxGetGroupNodesCount() > 0 then errorInfo = nvpxText.guiMenuNoGroupFF)
					)
					--format "count = %\n" count
					if target.count > 0 then
					(
						pxCurrentNodeType = type
					)
					if errorInfo != undefined then messagebox errorInfo
					if PX_PHYSTYPE_UNDEFINED != type then
					(
						--if target.count == 0 then           messagebox "Does not find qualified nodes."
						if PxGetSelectedHelpersCount() > 0 then messagebox nvpxText.guiMenuNoHelper
					)
				)
			)
		)
	)
)
